<?php $__env->startSection('template_title'); ?>
    <?php echo e(trans('installer_messages.environment.wizard.templateTitle')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <i
        class="fa fa-magic fa-fw"
        aria-hidden="true"
    ></i>
    <?php echo trans('installer_messages.environment.wizard.title'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <h4 class="mb-5 mt-0 font-body text-[26px]"><?php echo e(__('Setup')); ?></h4>

    <div class="tabs tabs-full">

        <input
            class="peer/tab1 invisible absolute h-0 w-0"
            class="tab-input"
            id="tab1"
            type="radio"
            name="tabs"
            checked
        />
        <label
            class="mx-3 inline-flex cursor-pointer rounded-md px-3 py-1 font-medium transition-colors peer-checked/tab1:bg-black peer-checked/tab1:bg-opacity-5"
            for="tab1"
        >
            <?php echo e(trans('installer_messages.environment.wizard.tabs.environment')); ?>

        </label>

        <input
            class="peer/tab2 invisible absolute h-0 w-0"
            class="tab-input"
            id="tab2"
            type="radio"
            name="tabs"
        />
        <label
            class="mx-3 inline-flex cursor-pointer rounded-md px-3 py-1 font-medium transition-colors peer-checked/tab2:bg-black peer-checked/tab2:bg-opacity-5"
            for="tab2"
        >
            <?php echo e(trans('installer_messages.environment.wizard.tabs.database')); ?>

        </label>

        <hr class="-mx-10 mb-10 mt-6 w-auto opacity-50">

        <form
            class="text-start text-[15px] peer-checked/tab1:[&_#tab1content]:block peer-checked/tab2:[&_#tab2content]:block peer-checked/tab3:[&_#tab3content]:block [&_input:not([type=radio])]:block [&_input:not([type=radio])]:h-10 [&_input:not([type=radio])]:w-full [&_input:not([type=radio])]:rounded-xl [&_input:not([type=radio])]:border [&_input:not([type=radio])]:border-solid [&_input:not([type=radio])]:bg-transparent [&_input:not([type=radio])]:px-4 [&_label]:mb-1 [&_label]:mt-6 [&_label]:block [&_label]:text-[14px] [&_label]:font-medium [&_label]:opacity-70 [&_select]:block [&_select]:h-10 [&_select]:w-full [&_select]:rounded-xl [&_select]:border [&_select]:border-solid [&_select]:bg-transparent [&_select]:px-4"
            method="post"
            action="<?php echo e(route('LaravelInstaller::environmentSaveWizard')); ?>"
        >
            <div
                class="hidden"
                id="tab1content"
            >
                <input
                    type="hidden"
                    name="_token"
                    value="<?php echo e(csrf_token()); ?>"
                >

                <div class="form-group <?php echo e($errors->has('app_name') ? ' has-error ' : ''); ?>">
                    <label for="app_name">
                        <?php echo e(trans('installer_messages.environment.wizard.form.app_name_label')); ?>

                    </label>
                    <input
                        id="app_name"
                        type="text"
                        name="app_name"
                        value=""
                        placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.app_name_placeholder')); ?>"
                    />
                    <?php if($errors->has('app_name')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('app_name')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="form-group <?php echo e($errors->has('app_url') ? ' has-error ' : ''); ?>">
                    <label for="app_url">
                        <?php echo e(trans('installer_messages.environment.wizard.form.app_url_label')); ?>

                    </label>

                    <input
                        id="app_url"
                        type="url"
                        name="app_url"
                        value="<?php echo e(url('/')); ?>"
                        placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.app_url_placeholder')); ?>"
                    />
                    <?php if($errors->has('app_url')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('app_url')); ?>

                        </span>
                    <?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginalb5e767ad160784309dfcad41e788743b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb5e767ad160784309dfcad41e788743b = $attributes; } ?>
<?php $component = App\View\Components\Alert::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Alert::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2']); ?>
                        <p>
                            <?php echo e(__('Please do not enter / at the end of the url. For Example; https://liquid-themes.com')); ?>

                        </p>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $attributes = $__attributesOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__attributesOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $component = $__componentOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__componentOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
                </div>

                <details class="mb-32 mt-9 open:mb-4">
                    <summary class="flex cursor-pointer list-none items-center gap-4 text-[15px]">
                        <span class="inline-flex grow items-center">
                            <span class="inline-block h-px w-full bg-black bg-opacity-5"></span>
                        </span>
                        <span class="inline-flex items-center gap-1 font-medium">
                            Advanced Options
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="20"
                                height="20"
                                viewBox="0 0 24 24"
                                stroke-width="1.5"
                                stroke="currentColor"
                                fill="none"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            >
                                <path d="M6 9l6 6l6 -6"></path>
                            </svg>
                        </span>
                        <span class="inline-flex grow items-center">
                            <span class="inline-block h-px w-full bg-black bg-opacity-5"></span>
                        </span>
                    </summary>
                    <div class="form-group <?php echo e($errors->has('environment') ? ' has-error ' : ''); ?>">
                        <label for="environment">
                            <?php echo e(trans('installer_messages.environment.wizard.form.app_environment_label')); ?>

                        </label>
                        <select
                            id="environment"
                            name="environment"
                            onchange='checkEnvironment(this.value);'
                        >
                            <option
                                value="production"
                                selected
                            ><?php echo e(trans('installer_messages.environment.wizard.form.app_environment_label_production')); ?></option>
                            <option value="local"><?php echo e(trans('installer_messages.environment.wizard.form.app_environment_label_local')); ?></option>
                            <option value="development"><?php echo e(trans('installer_messages.environment.wizard.form.app_environment_label_developement')); ?></option>
                            <option value="qa"><?php echo e(trans('installer_messages.environment.wizard.form.app_environment_label_qa')); ?></option>
                            <option value="other"><?php echo e(trans('installer_messages.environment.wizard.form.app_environment_label_other')); ?></option>
                        </select>
                        <div
                            class="mt-2"
                            id="environment_text_input"
                            style="display: none;"
                        >
                            <input
                                id="environment_custom"
                                type="text"
                                name="environment_custom"
                                placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.app_environment_placeholder_other')); ?>"
                            />
                        </div>
                        <?php if($errors->has('environment')): ?>
                            <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                                <i
                                    class="fa fa-fw fa-exclamation-triangle"
                                    aria-hidden="true"
                                ></i>
                                <?php echo e($errors->first('environment')); ?>

                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group <?php echo e($errors->has('app_debug') ? ' has-error ' : ''); ?>">
                        <label
                            class="!mb-2"
                            for="app_debug"
                        >
                            <?php echo e(trans('installer_messages.environment.wizard.form.app_debug_label')); ?>

                        </label>
                        <div class="flex items-center gap-3">
                            <label
                                class="!mt-0"
                                for="app_debug_true"
                            >
                                <input
                                    id="app_debug_true"
                                    type="radio"
                                    name="app_debug"
                                    value=true
                                />
                                <?php echo e(trans('installer_messages.environment.wizard.form.app_debug_label_true')); ?>

                            </label>
                            <label
                                class="!mt-0"
                                for="app_debug_false"
                            >
                                <input
                                    id="app_debug_false"
                                    type="radio"
                                    name="app_debug"
                                    value=false
                                    checked
                                />
                                <?php echo e(trans('installer_messages.environment.wizard.form.app_debug_label_false')); ?>

                            </label>
                        </div>
                        <?php if($errors->has('app_debug')): ?>
                            <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                                <i
                                    class="fa fa-fw fa-exclamation-triangle"
                                    aria-hidden="true"
                                ></i>
                                <?php echo e($errors->first('app_debug')); ?>

                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group <?php echo e($errors->has('app_log_level') ? ' has-error ' : ''); ?>">
                        <label for="app_log_level">
                            <?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label')); ?>

                        </label>
                        <select
                            id="app_log_level"
                            name="app_log_level"
                        >
                            <option
                                value="debug"
                                selected
                            ><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_debug')); ?></option>
                            <option value="info"><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_info')); ?></option>
                            <option value="notice"><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_notice')); ?></option>
                            <option value="warning"><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_warning')); ?></option>
                            <option value="error"><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_error')); ?></option>
                            <option value="critical"><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_critical')); ?></option>
                            <option value="alert"><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_alert')); ?></option>
                            <option value="emergency"><?php echo e(trans('installer_messages.environment.wizard.form.app_log_level_label_emergency')); ?></option>
                        </select>
                        <?php if($errors->has('app_log_level')): ?>
                            <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                                <i
                                    class="fa fa-fw fa-exclamation-triangle"
                                    aria-hidden="true"
                                ></i>
                                <?php echo e($errors->first('app_log_level')); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                </details>

                <div class="mt-6 text-center">
                    <button
                        class="flex w-full items-center justify-center gap-2 rounded-xl p-2 font-medium shadow-[0_4px_10px_rgba(0,0,0,0.05)] transition-all duration-300 hover:scale-105 hover:bg-black hover:text-white"
                        onclick="return showDatabaseSettings();"
                        type="button"
                    >
                        <?php echo e(trans('installer_messages.environment.wizard.form.buttons.setup_database')); ?>

                        <svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="18"
                            height="18"
                            viewBox="0 0 24 24"
                            stroke-width="2"
                            stroke="currentColor"
                            fill="none"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        >
                            <path d="M9 6l6 6l-6 6"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <div
                class="hidden"
                id="tab2content"
            >

                <div class="form-group <?php echo e($errors->has('database_connection') ? ' has-error ' : ''); ?>">
                    <label for="database_connection">
                        <?php echo e(trans('installer_messages.environment.wizard.form.db_connection_label')); ?>

                    </label>
                    <select
                        id="database_connection"
                        name="database_connection"
                    >
                        <option
                            value="mysql"
                            selected
                        ><?php echo e(trans('installer_messages.environment.wizard.form.db_connection_label_mysql')); ?></option>
                        <option value="sqlite"><?php echo e(trans('installer_messages.environment.wizard.form.db_connection_label_sqlite')); ?></option>
                        <option value="pgsql"><?php echo e(trans('installer_messages.environment.wizard.form.db_connection_label_pgsql')); ?></option>
                        <option value="sqlsrv"><?php echo e(trans('installer_messages.environment.wizard.form.db_connection_label_sqlsrv')); ?></option>
                    </select>
                    <?php if($errors->has('database_connection')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('database_connection')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="form-group <?php echo e($errors->has('database_hostname') ? ' has-error ' : ''); ?>">
                    <label for="database_hostname">
                        <?php echo e(trans('installer_messages.environment.wizard.form.db_host_label')); ?>

                    </label>
                    <input
                        id="database_hostname"
                        type="text"
                        name="database_hostname"
                        value="127.0.0.1"
                        placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.db_host_placeholder')); ?>"
                    />
                    <?php if($errors->has('database_hostname')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('database_hostname')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="form-group <?php echo e($errors->has('database_port') ? ' has-error ' : ''); ?>">
                    <label for="database_port">
                        <?php echo e(trans('installer_messages.environment.wizard.form.db_port_label')); ?>

                    </label>
                    <input
                        id="database_port"
                        type="number"
                        name="database_port"
                        value="3306"
                        placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.db_port_placeholder')); ?>"
                    />
                    <?php if($errors->has('database_port')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('database_port')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="form-group <?php echo e($errors->has('database_name') ? ' has-error ' : ''); ?>">
                    <label for="database_name">
                        <?php echo e(trans('installer_messages.environment.wizard.form.db_name_label')); ?>

                    </label>
                    <input
                        id="database_name"
                        type="text"
                        name="database_name"
                        value=""
                        placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.db_name_placeholder')); ?>"
                    />
                    <?php if($errors->has('database_name')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('database_name')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="form-group <?php echo e($errors->has('database_username') ? ' has-error ' : ''); ?>">
                    <label for="database_username">
                        <?php echo e(trans('installer_messages.environment.wizard.form.db_username_label')); ?>

                    </label>
                    <input
                        id="database_username"
                        type="text"
                        name="database_username"
                        value=""
                        placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.db_username_placeholder')); ?>"
                    />
                    <?php if($errors->has('database_username')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('database_username')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="form-group <?php echo e($errors->has('database_password') ? ' has-error ' : ''); ?>">
                    <label for="database_password">
                        <?php echo e(trans('installer_messages.environment.wizard.form.db_password_label')); ?>

                    </label>
                    <input
                        id="database_password"
                        type="password"
                        name="database_password"
                        value=""
                        placeholder="<?php echo e(trans('installer_messages.environment.wizard.form.db_password_placeholder')); ?>"
                    />
                    <?php if($errors->has('database_password')): ?>
                        <span class="mt-1 block rounded-md bg-red-100 px-2 py-1 text-sm text-red-600">
                            <i
                                class="fa fa-fw fa-exclamation-triangle"
                                aria-hidden="true"
                            ></i>
                            <?php echo e($errors->first('database_password')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <div class="mt-6 text-center">
                    <button
                        class="flex w-full items-center justify-center gap-2 rounded-xl p-2 font-medium shadow-[0_4px_10px_rgba(0,0,0,0.05)] transition-all duration-300 hover:scale-105 hover:bg-black hover:text-white"
                        type="submit"
                    >
                        <?php echo e(trans('installer_messages.environment.wizard.form.buttons.install')); ?>

                        <svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="18"
                            height="18"
                            viewBox="0 0 24 24"
                            stroke-width="2"
                            stroke="currentColor"
                            fill="none"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        >
                            <path d="M9 6l6 6l-6 6"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </form>

    </div>

    <script type="text/javascript">
        function checkEnvironment(val) {
            var element = document.getElementById('environment_text_input');
            if (val == 'other') {
                element.style.display = 'block';
            } else {
                element.style.display = 'none';
            }
        }

        function showDatabaseSettings() {
            document.getElementById('tab2').checked = true;
        }

        function showApplicationSettings() {
            document.getElementById('tab3').checked = true;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendor.installer.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aineptune/public_html/resources/views/vendor/installer/environment-wizard.blade.php ENDPATH**/ ?>