<?php
    $auth = Auth::user();
    $plan = $auth->activePlan();
    $plan_type = 'regular';
    $upgrade = false;
    $overlay_link_href = '';
    $overlay_link_label = 'Create Workbook';

    if ($plan != null) {
        $plan_type = strtolower($plan->plan_type);
    }

    if ($app_is_demo) {
        if ($item->premium == 1 && $plan_type === 'regular') {
            $upgrade = true;
        }
    } else {
        if (!$auth->isAdmin() && $item->premium == 1 && $plan_type === 'regular') {
            $upgrade = true;
        }
    }

    if ($upgrade) {
        $overlay_link_href = route('dashboard.user.payment.subscription');
        $overlay_link_label = 'Upgrade';
    } elseif ($item->type === 'text' || $item->type === 'code') {
        if ($item->slug === 'ai_article_wizard_generator') {
            $overlay_link_href = route('dashboard.user.openai.articlewizard.new');
        } else {
            $overlay_link_href = route('dashboard.user.openai.generator.workbook', $item->slug);
        }
    } elseif ($item->type === 'voiceover' || $item->type === 'audio' || $item->type === \App\Domains\Entity\Enums\EntityEnum::ISOLATOR->value  || $item->type === 'image') {
        $overlay_link_href = route('dashboard.user.openai.generator', $item->slug);
        $overlay_link_label = 'Create';
    } else {
        $overlay_link_href = '#';
        $overlay_link_label = 'No Tokens Left';
    }

    $item_filters = $item->filters;

    if (isFavorited($item->id)) {
        $item_filters .= ',favorite';
    }
?>

<?php if (isset($component)) { $__componentOriginal740c66ff9bbfcb19a96a45ba2fa42d64 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal740c66ff9bbfcb19a96a45ba2fa42d64 = $attributes; } ?>
<?php $component = App\View\Components\Card::resolve(['size' => 'none','roundness' => ''.e(Theme::getSetting('defaultVariations.card.roundness', 'default') === 'default' ? 'none' : Theme::getSetting('defaultVariations.card.roundness', 'default')).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Card::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class:body' => 'static','data-filter' => ''.e($item_filters).'','class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(\Illuminate\Support\Arr::toCssClasses([
            'lqd-generator-item group relative w-full px-5 pb-10 pt-8 lg:px-10 2xl:px-16',
            'border-t-0 border-s-0 border-b border-e' =>
                Theme::getSetting('defaultVariations.card.variant', 'outline') ===
                'outline',
            'hidden' =>
                null !== request()->query('filter') &&
                !str()->contains($item_filters, request()->query('filter')),
        ])),'x-data' => true,':class' => '{ \'hidden\': $store.generatorsFilter.filter !== \'all\' && (\''.e($item_filters).'\').search($store.generatorsFilter.filter) < 0 }']); ?>
    <?php if (isset($component)) { $__componentOriginalfcf158437a8f91c7c912d5fdba2a4dd9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfcf158437a8f91c7c912d5fdba2a4dd9 = $attributes; } ?>
<?php $component = App\View\Components\LqdIcon::resolve(['size' => 'xl','activeBadge' => true,'activeBadgeCondition' => ''.e($item->active == 1).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lqd-icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LqdIcon::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'lqd-generator-item-icon mb-5 bg-[--color] group-hover:scale-110 group-hover:shadow-lg','style' => '--color: '.e($item->color).'']); ?>
        <span class="size-5 flex items-center justify-center transition-transform group-hover:scale-110">
            <?php if($item->image !== 'none'): ?>
                <?php echo html_entity_decode($item->image); ?>

            <?php endif; ?>
        </span>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfcf158437a8f91c7c912d5fdba2a4dd9)): ?>
<?php $attributes = $__attributesOriginalfcf158437a8f91c7c912d5fdba2a4dd9; ?>
<?php unset($__attributesOriginalfcf158437a8f91c7c912d5fdba2a4dd9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfcf158437a8f91c7c912d5fdba2a4dd9)): ?>
<?php $component = $__componentOriginalfcf158437a8f91c7c912d5fdba2a4dd9; ?>
<?php unset($__componentOriginalfcf158437a8f91c7c912d5fdba2a4dd9); ?>
<?php endif; ?>
    <div class="lqd-generator-item-info">
        <h4 class="relative mb-3.5 inline-block text-lg">
            <?php echo e(__($item->title)); ?>

            <span
                    class="absolute start-[calc(100%+0.35rem)] top-1/2 inline-block -translate-x-1 -translate-y-1/2 align-bottom opacity-0 transition-all group-hover:translate-x-0 group-hover:!opacity-100 rtl:-scale-x-100"
            >
                <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-chevron-right'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
            </span>
        </h4>
        <p class="opacity-85 m-0">
            <?php echo e(__($item->description)); ?>

        </p>
    </div>

    <?php if($item->active == 1): ?>
        <?php if(!$upgrade): ?>
            <?php if (isset($component)) { $__componentOriginal922563da9543e5e61c91039c444c4ae8 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal922563da9543e5e61c91039c444c4ae8 = $attributes; } ?>
<?php $component = App\View\Components\FavoriteButton::resolve(['id' => ''.e($item->id).'','isFavorite' => ''.e(isFavorited($item->id)).'','updateUrl' => '/dashboard/user/openai/favorite'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('favorite-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\FavoriteButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'absolute end-4 top-4']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal922563da9543e5e61c91039c444c4ae8)): ?>
<?php $attributes = $__attributesOriginal922563da9543e5e61c91039c444c4ae8; ?>
<?php unset($__attributesOriginal922563da9543e5e61c91039c444c4ae8); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal922563da9543e5e61c91039c444c4ae8)): ?>
<?php $component = $__componentOriginal922563da9543e5e61c91039c444c4ae8; ?>
<?php unset($__componentOriginal922563da9543e5e61c91039c444c4ae8); ?>
<?php endif; ?>
        <?php endif; ?>

        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
            'absolute left-0 top-0 z-2 h-full w-full transition-all',
            'bg-background/75' => $upgrade || $overlay_link_href === '#',
        ]); ?>">
            <a
                    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                        'absolute left-0 top-0 inline-block h-full w-full overflow-hidden',
                        'flex items-center justify-center font-medium' =>
                            $upgrade || $overlay_link_href === '#',
                        '-indent-[99999px]' => !$upgrade && $overlay_link_href !== '#',
                    ]); ?>"
                    href="<?php echo e($overlay_link_href); ?>"
            >
                <?php if($upgrade || $overlay_link_href === '#'): ?>
                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                        'inline-block rounded-md px-2 py-0.5',
                        'absolute end-4 top-4 bg-cyan-100 text-black' => $upgrade,
                        'bg-foreground text-background' => $overlay_link_href === '#',
                    ]); ?>">
                        <?php endif; ?>
                        <?php echo e(__($overlay_link_label)); ?>

                        <?php if($upgrade): ?>
                    </span>
                <?php endif; ?>
            </a>
        </div>
    <?php endif; ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal740c66ff9bbfcb19a96a45ba2fa42d64)): ?>
<?php $attributes = $__attributesOriginal740c66ff9bbfcb19a96a45ba2fa42d64; ?>
<?php unset($__attributesOriginal740c66ff9bbfcb19a96a45ba2fa42d64); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal740c66ff9bbfcb19a96a45ba2fa42d64)): ?>
<?php $component = $__componentOriginal740c66ff9bbfcb19a96a45ba2fa42d64; ?>
<?php unset($__componentOriginal740c66ff9bbfcb19a96a45ba2fa42d64); ?>
<?php endif; ?>
<?php /**PATH /home/aineptune/public_html/resources/views/default/components/generator-item.blade.php ENDPATH**/ ?>