<?php
	use App\Domains\Entity\Enums\EntityEnum;
?>


<?php $__env->startSection('title', __(\App\Domains\Engine\Enums\EngineEnum::DEEP_SEEK->label().' Settings')); ?>
<?php $__env->startSection('titlebar_actions', ''); ?>
<?php $__env->startSection('titlebar_subtitle', __('This API key is used for all AI-powered features and Content Writing')); ?>

<?php $__env->startSection('additional_css'); ?>
	<link
		href="<?php echo e(custom_theme_url('/assets/libs/select2/select2.min.css')); ?>"
		rel="stylesheet"
	/>
	<style>

	</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('settings'); ?>
	<form
		id="settings_form"
		method="POST"
		action="<?php echo e(route("dashboard.admin.settings.deepseek.save")); ?>"
	>
		<?php echo csrf_field(); ?>
		<h3 class="mb-[25px] text-[20px]"><?php echo e(__('Deepseek Settings')); ?></h3>
		<div class="row">
			<!-- TODO OPENAI API KEY -->
			<?php if($app_is_demo): ?>
				<div class="col-md-12">
					<div class="mb-3">
						<label class="form-label"><?php echo e(__('Deepseek API Secret')); ?></label>
						<input
							class="form-control"
							id="deepseek_api_secret"
							type="text"
							name="deepseek_api_secret"
							value="*********************"
						>
					</div>
				</div>
			<?php else: ?>
				<div class="col-md-12">
					<div
						class="form-control mb-3 border-none p-0 [&_.select2-selection--multiple]:!rounded-[--tblr-border-radius] [&_.select2-selection--multiple]:!border-[--tblr-border-color] [&_.select2-selection--multiple]:!p-[1em_1.23em]">
						<label class="form-label"><?php echo e(__('Deepseek API Secret')); ?></label>

						<select
							class="form-control select2"
							id="deepseek_api_secret"
							name="deepseek_api_secret[]"
							multiple
						>
							<?php $__currentLoopData = explode(',', setting('deepseek_api_secret')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secret): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option
									value="<?php echo e($secret); ?>"
									selected
								><?php echo e($secret); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>

						<?php if (isset($component)) { $__componentOriginalb5e767ad160784309dfcad41e788743b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb5e767ad160784309dfcad41e788743b = $attributes; } ?>
<?php $component = App\View\Components\Alert::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Alert::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2']); ?>
							<p>
								<?php echo e(__('You can enter as much API KEY as you want. Click "Enter" after each api key.')); ?>

							</p>
						 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $attributes = $__attributesOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__attributesOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $component = $__componentOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__componentOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
						<?php if (isset($component)) { $__componentOriginalb5e767ad160784309dfcad41e788743b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb5e767ad160784309dfcad41e788743b = $attributes; } ?>
<?php $component = App\View\Components\Alert::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Alert::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2']); ?>
							<p>
								<?php echo e(__('Please ensure that your Deepseek API key is fully functional and billing defined on your DeepSeek account.')); ?>

							</p>
						 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $attributes = $__attributesOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__attributesOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $component = $__componentOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__componentOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
						<a
							class="btn btn-primary mb-2 mt-2 w-full"
							href="<?php echo e(route('dashboard.admin.settings.deepseek.test')); ?>"
							target="_blank"
						>
							<?php echo e(__('After Saving Setting, Click Here to Test Your Api Keys')); ?>

						</a>
					</div>
				</div>
			<?php endif; ?>

			<div class="col-md-12">
				<div class="mb-3">
					<?php
						$deepseekDrivers = \App\Domains\Entity\EntityStats::word()
							->filterByEngine(\App\Domains\Engine\Enums\EngineEnum::DEEP_SEEK)
							->list();
						$current_deepseek_model = EntityEnum::fromSlug(setting('deepseek_default_model', EntityEnum::DEEPSEEK_CHAT->slug()))->slug();
					?>
					<?php if (isset($component)) { $__componentOriginal0b52e49ec80893bef9418d4370c1802c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0b52e49ec80893bef9418d4370c1802c = $attributes; } ?>
<?php $component = App\View\Components\ModelSelectListWithChangeAlert::resolve(['listLabel' => 'Default Deepseek Word Model','listId' => 'deepseek_default_model','currentModel' => ''.e($current_deepseek_model).'','drivers' => $deepseekDrivers] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('model-select-list-with-change-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ModelSelectListWithChangeAlert::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0b52e49ec80893bef9418d4370c1802c)): ?>
<?php $attributes = $__attributesOriginal0b52e49ec80893bef9418d4370c1802c; ?>
<?php unset($__attributesOriginal0b52e49ec80893bef9418d4370c1802c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0b52e49ec80893bef9418d4370c1802c)): ?>
<?php $component = $__componentOriginal0b52e49ec80893bef9418d4370c1802c; ?>
<?php unset($__componentOriginal0b52e49ec80893bef9418d4370c1802c); ?>
<?php endif; ?>
				</div>

				<div class="col-md-12">
					<div class="mb-3">
						<label class="form-label"><?php echo e(__('Maximum Output Length')); ?></label>
						<input
							class="form-control"
							id="deepseek_max_output_length"
							type="number"
							name="deepseek_max_output_length"
							min="0"
							value="<?php echo e(setting('deepseek_max_output_length', 200)); ?>"
							required
						>
						<?php if (isset($component)) { $__componentOriginalb5e767ad160784309dfcad41e788743b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb5e767ad160784309dfcad41e788743b = $attributes; } ?>
<?php $component = App\View\Components\Alert::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Alert::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2']); ?>
							<p>
								<?php echo e(__('In Words. OpenAI has a hard limit based on Token limits for each model. Refer to OpenAI documentation to learn more. As a recommended by OpenAI, max result length is capped at 2000 tokens')); ?>

							</p>
							<p>
								<?php echo e(__('The maximum output length refers to the point at which the AI-generated response will stop. It can occur when the response reaches 4096 bytes or when the generated content is considered sufficient for the given context.')); ?>

							</p>
						 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $attributes = $__attributesOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__attributesOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb5e767ad160784309dfcad41e788743b)): ?>
<?php $component = $__componentOriginalb5e767ad160784309dfcad41e788743b; ?>
<?php unset($__componentOriginalb5e767ad160784309dfcad41e788743b); ?>
<?php endif; ?>
					</div>
				</div>

			</div>

			<button
				class="btn btn-primary w-full"
				id="settings_button"
				form="settings_form"
				
			>
				<?php echo e(__('Save')); ?>

			</button>
		</div>
	</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
	<script>
		function checkMaxOutputLength() {
			var maxOutputLength = document.getElementById("deepseek_max_output_length").value;
			var msg = "<?php echo e(__('The maximum output length is set above 2000. Are you sure you want to continue?')); ?>";
			if (maxOutputLength > 2000) {
				var confirmation = confirm(msg);
				if (!confirmation) {
					event.preventDefault();
				}
			}
		}
	</script>

	<script src="<?php echo e(custom_theme_url('/assets/js/panel/settings.js')); ?>"></script>
	<script src="<?php echo e(custom_theme_url('/assets/libs/select2/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('panel.layout.settings', ['layout' => 'wide'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aineptune/public_html/resources/views/default/panel/admin/settings/deepseek.blade.php ENDPATH**/ ?>